<?php
session_start();
require_once '../includes/config.php';

// If already logged in, redirect to home
if(isset($_SESSION['user_id'])) {
    header("Location: ../index.php");
    exit();
}

$page_title = "Register";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - MyKivotosRailways</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/auth.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
    </style>
</head>
<body class="auth-page">
    <div class="auth-container">
        <!-- Brand Header -->
        <div class="auth-brand">
            <svg width="40" height="40" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect x="3" y="8" width="18" height="12" rx="2" stroke="var(--dark)" stroke-width="2"/>
                <path d="M7 8V6C7 4.89543 7.89543 4 9 4H15C16.1046 4 17 4.89543 17 6V8" stroke="var(--dark)" stroke-width="2"/>
                <circle cx="8" cy="17" r="1.5" fill="var(--dark)"/>
                <circle cx="16" cy="17" r="1.5" fill="var(--dark)"/>
            </svg>
            <h1>MyKivotosRailways</h1>
        </div>

        <p class="auth-subtitle">Join MyKivotosRailways for seamless travel booking</p>

        <!-- Register Card -->
        <div class="auth-card">
            <h2>Create Account</h2>
            <p class="auth-description">Join MyKivotosRailways for seamless travel booking</p>

            <!-- Display Messages -->
            <?php if(isset($_SESSION['error'])): ?>
                <div class="error-message">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                        <path d="M12 8v4m0 4h.01" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    <?php 
                    echo htmlspecialchars($_SESSION['error']); 
                    unset($_SESSION['error']);
                    ?>
                </div>
            <?php endif; ?>

            <!-- Register Form -->
            <form action="../auth/register-process.php" method="POST" class="auth-form" id="registerForm">
                <div class="form-group">
                    <label for="fullname">Full Name</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="8" r="4" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M6 21C6 17.134 8.68629 14 12 14C15.3137 14 18 17.134 18 21" stroke="var(--gray)" stroke-width="2"/>
                        </svg>
                        <input 
                            type="text" 
                            id="fullname" 
                            name="fullname" 
                            placeholder="Enter your full name"
                            value="<?php echo isset($_SESSION['old_fullname']) ? htmlspecialchars($_SESSION['old_fullname']) : ''; ?>"
                            required
                        >
                    </div>
                </div>

                <div class="form-group">
                    <label for="email">Email Address</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect x="3" y="5" width="18" height="14" rx="2" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M3 8L12 13L21 8" stroke="var(--gray)" stroke-width="2"/>
                        </svg>
                        <input 
                            type="email" 
                            id="email" 
                            name="email" 
                            placeholder="Enter your email"
                            value="<?php echo isset($_SESSION['old_email']) ? htmlspecialchars($_SESSION['old_email']) : ''; ?>"
                            required
                        >
                    </div>
                </div>

                <div class="form-group">
                    <label for="username">Username</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="3" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M12 2v3m0 14v3M2 12h3m14 0h3" stroke="var(--gray)" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                        <input 
                            type="text" 
                            id="username" 
                            name="username" 
                            placeholder="Choose a username"
                            value="<?php echo isset($_SESSION['old_username']) ? htmlspecialchars($_SESSION['old_username']) : ''; ?>"
                            required
                            pattern="[a-zA-Z0-9_]{3,20}"
                            title="Username must be 3-20 characters (letters, numbers, underscore only)"
                        >
                    </div>
                    <small class="form-hint">3-20 characters, letters, numbers and underscore only</small>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect x="5" y="11" width="14" height="10" rx="2" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M8 11V7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7V11" stroke="var(--gray)" stroke-width="2"/>
                        </svg>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            placeholder="Create a password"
                            required
                            minlength="6"
                        >
                    </div>
                    <small class="form-hint">Minimum 6 characters</small>
                </div>

                <div class="form-group">
                    <label for="confirm_password">Confirm Password</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect x="5" y="11" width="14" height="10" rx="2" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M8 11V7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7V11" stroke="var(--gray)" stroke-width="2"/>
                        </svg>
                        <input 
                            type="password" 
                            id="confirm_password" 
                            name="confirm_password" 
                            placeholder="Confirm your password"
                            required
                        >
                    </div>
                    <!-- Gmail-style Show Password Checkbox -->
                    <div class="password-toggle-wrapper">
                        <input type="checkbox" id="showPasswords" onchange="togglePasswords(this)">
                        <label for="showPasswords">Show password</label>
                    </div>
                </div>

                <div class="form-group">
                    <label class="checkbox-label">
                        <input type="checkbox" name="terms" required>
                        <span>I agree to the <a href="#terms">Terms & Conditions</a> and <a href="#privacy">Privacy Policy</a></span>
                    </label>
                </div>

                <button type="submit" class="btn-primary btn-block">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M16 21v-2a4 4 0 00-4-4H6a4 4 0 00-4 4v2" stroke="currentColor" stroke-width="2"/>
                        <circle cx="9" cy="7" r="4" stroke="currentColor" stroke-width="2"/>
                        <line x1="19" y1="8" x2="19" y2="14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        <line x1="22" y1="11" x2="16" y2="11" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    Create Account
                </button>
            </form>

            <p class="auth-switch">
                Already have an account? 
                <a href="login.php">Login here</a>
            </p>
        </div>

        <!-- Footer Links -->
        <div class="auth-footer">
            <a href="#privacy">Privacy Policy</a>
            <span>·</span>
            <a href="#terms">Terms of Service</a>
            <span>·</span>
            <a href="#help">Help Center</a>
        </div>
    </div>
    
    <script>
        // Toggle both password fields visibility
        function togglePasswords(checkbox) {
            const password = document.getElementById('password');
            const confirmPassword = document.getElementById('confirm_password');
            const type = checkbox.checked ? 'text' : 'password';
            password.type = type;
            confirmPassword.type = type;
        }
    </script>
    <script src="../assets/js/main.js"></script>
</body>
</html>