<?php
$page_title = "Promotions";
require_once '../includes/header.php';
require_once '../includes/navbar.php';

// Get filter
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'All';

// Fetch promotions
if($filter == 'All') {
    $promo_query = "SELECT * FROM promotions WHERE status = 'active' ORDER BY created_at DESC";
    $promo_result = mysqli_query($conn, $promo_query);
} else {
    $promo_query = "SELECT * FROM promotions WHERE promo_type = ? AND status = 'active' ORDER BY created_at DESC";
    $stmt = mysqli_prepare($conn, $promo_query);
    mysqli_stmt_bind_param($stmt, "s", $filter);
    mysqli_stmt_execute($stmt);
    $promo_result = mysqli_stmt_get_result($stmt);
}
?>
<link rel="stylesheet" href="../assets/css/style.css">
<link rel="stylesheet" href="../assets/css/auth.css">
<link rel="stylesheet" href="../assets/css/responsive.css">
<section class="promotions-page">
    <div class="container">
        <!-- Page Header -->
        <div class="page-header">
            <h1>Promotions</h1>
            <p>Discover amazing deals and discounts for your railway journeys</p>
        </div>

        <!-- Filter Section -->
        <div class="filter-section">
            <span class="filter-label">Filter by:</span>
            <div class="filter-buttons">
                <a href="?filter=All" class="filter-btn <?php echo ($filter == 'All') ? 'active' : ''; ?>">
                    All Promotions
                </a>
                <a href="?filter=Seasonal" class="filter-btn <?php echo ($filter == 'Seasonal') ? 'active' : ''; ?>">
                    Seasonal
                </a>
                <a href="?filter=Student" class="filter-btn <?php echo ($filter == 'Student') ? 'active' : ''; ?>">
                    Student
                </a>
                <a href="?filter=Group" class="filter-btn <?php echo ($filter == 'Group') ? 'active' : ''; ?>">
                    Group
                </a>
            </div>
        </div>

        <!-- Promotions Grid -->
        <div class="promotions-grid">
            <?php if(mysqli_num_rows($promo_result) > 0): ?>
                <?php while($promo = mysqli_fetch_assoc($promo_result)): ?>
                    <div class="promotion-card">
                        <div class="promotion-image">
                            <?php if(!empty($promo['image']) && file_exists('../assets/img/promotions/' . $promo['image'])): ?>
                                <img src="../assets/img/promotions/<?php echo htmlspecialchars($promo['image']); ?>" 
                                     alt="<?php echo htmlspecialchars($promo['title']); ?>">
                            <?php else: ?>
                                <div class="promotion-placeholder">
                                    <span><?php echo htmlspecialchars($promo['promo_type']); ?> Promotion Banner</span>
                                </div>
                            <?php endif; ?>
                            <span class="promo-badge"><?php echo $promo['discount_percentage']; ?>% OFF</span>
                        </div>

                        <div class="promotion-content">
                            <div class="promo-type-tag"><?php echo htmlspecialchars($promo['promo_type']); ?></div>
                            <h3><?php echo htmlspecialchars($promo['title']); ?></h3>
                            <p><?php echo htmlspecialchars($promo['description']); ?></p>

                            <div class="promo-details">
                                <div class="promo-detail-item">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="3" y="6" width="18" height="15" rx="2" stroke="currentColor" stroke-width="2"/>
                                        <path d="M3 10h18M8 3v6m8-6v6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                    <div>
                                        <span class="detail-label">Valid until:</span>
                                        <span class="detail-value"><?php echo date('M d, Y', strtotime($promo['end_date'])); ?></span>
                                    </div>
                                </div>

                                <div class="promo-detail-item">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 2v4M15 2v4M3 10h18M5 4h14a2 2 0 012 2v14a2 2 0 01-2 2H5a2 2 0 01-2-2V6a2 2 0 012-2z" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                    <div>
                                        <span class="detail-label">Start date:</span>
                                        <span class="detail-value"><?php echo date('M d, Y', strtotime($promo['start_date'])); ?></span>
                                    </div>
                                </div>
                            </div>

                            <a href="../pages/schedule.php" class="btn-promo-book">Book Now</a>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="empty-state" style="grid-column: 1/-1;">
                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M21 11.5a8.38 8.38 0 01-.9 3.8 8.5 8.5 0 01-7.6 4.7 8.38 8.38 0 01-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 01-.9-3.8 8.5 8.5 0 014.7-7.6 8.38 8.38 0 013.8-.9h.5a8.48 8.48 0 018 8v.5z" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    <h3>No Promotions Found</h3>
                    <p>There are currently no active promotions in this category.</p>
                    <a href="?filter=All" class="btn-primary">View All Promotions</a>
                </div>
            <?php endif; ?>
        </div>

        <!-- Info Section -->
        <div class="promo-info-section">
            <div class="info-card">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                    <path d="M12 16v-4m0-4h.01" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                </svg>
                <div>
                    <h4>How to Use Promotions</h4>
                    <p>Select your promotion and book your tickets. The discount will be automatically applied during checkout.</p>
                </div>
            </div>

            <div class="info-card">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M22 11.08V12a10 10 0 11-5.93-9.14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    <path d="M22 4L12 14.01l-3-3" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                </svg>
                <div>
                    <h4>Terms & Conditions Apply</h4>
                    <p>Each promotion has specific terms and validity periods. Please read the details before booking.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once '../includes/footer.php'; ?>