<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/auth.php';

// Store success message before destroying session
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'User';

// Destroy the session
$_SESSION = array();

// Destroy session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time()-3600, '/');
}

// Destroy session
session_destroy();

// Start new session for the success message
session_start();
$_SESSION['success'] = "Goodbye, $username! You have been logged out successfully.";

// Redirect to home page
header("Location: ../index.php");
exit();
?>