<?php
session_start();
require_once '../includes/config.php';

// If already logged in, redirect to home
if(isset($_SESSION['user_id'])) {
    header("Location: ../index.php");
    exit();
}

$page_title = "Login";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - MyKivotosRailways</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/auth.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
    </style>
</head>
<body class="auth-page">
    <div class="auth-container">
        <!-- Brand Header -->
        <div class="auth-brand">
            <svg width="40" height="40" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect x="3" y="8" width="18" height="12" rx="2" stroke="var(--dark)" stroke-width="2"/>
                <path d="M7 8V6C7 4.89543 7.89543 4 9 4H15C16.1046 4 17 4.89543 17 6V8" stroke="var(--dark)" stroke-width="2"/>
                <circle cx="8" cy="17" r="1.5" fill="var(--dark)"/>
                <circle cx="16" cy="17" r="1.5" fill="var(--dark)"/>
            </svg>
            <h1>MyKivotosRailways</h1>
        </div>

        <p class="auth-subtitle">Your journey starts here</p>

        <!-- Login Card -->
        <div class="auth-card">
            <h2>Welcome Back</h2>
            <p class="auth-description">Sign in to your account</p>

            <!-- Display Messages -->
            <?php if(isset($_SESSION['error'])): ?>
                <div class="error-message">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                        <path d="M12 8v4m0 4h.01" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    <?php 
                    echo htmlspecialchars($_SESSION['error']); 
                    unset($_SESSION['error']);
                    ?>
                </div>
            <?php endif; ?>

            <?php if(isset($_SESSION['success'])): ?>
                <div class="success-message">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                        <path d="M9 12l2 2 4-4" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    <?php 
                    echo htmlspecialchars($_SESSION['success']); 
                    unset($_SESSION['success']);
                    ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form action="../auth/login-process.php" method="POST" class="auth-form">
                <div class="form-group">
                    <label for="email">Email or Username</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="8" r="4" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M6 21C6 17.134 8.68629 14 12 14C15.3137 14 18 17.134 18 21" stroke="var(--gray)" stroke-width="2"/>
                        </svg>
                        <input 
                            type="text" 
                            id="email" 
                            name="email" 
                            placeholder="Enter your email or username"
                            value="<?php echo isset($_SESSION['old_email']) ? htmlspecialchars($_SESSION['old_email']) : ''; ?>"
                            required
                        >
                    </div>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <div class="input-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect x="5" y="11" width="14" height="10" rx="2" stroke="var(--gray)" stroke-width="2"/>
                            <path d="M8 11V7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7V11" stroke="var(--gray)" stroke-width="2"/>
                        </svg>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            placeholder="Enter your password"
                            required
                        >
                    </div>
                    <!-- Gmail-style Show Password Checkbox -->
                    <div class="password-toggle-wrapper">
                        <input type="checkbox" id="showPassword" onchange="togglePassword('password', this)">
                        <label for="showPassword">Show password</label>
                    </div>
                </div>

                <div class="form-options">
                    <label class="checkbox-label">
                        <input type="checkbox" name="remember" value="1">
                        <span>Remember me</span>
                    </label>
                    <a href="#" class="forgot-link">Forgot your password?</a>
                </div>

                <button type="submit" class="btn-primary btn-block">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M15 3H19C20.1046 3 21 3.89543 21 5V19C21 20.1046 20.1046 21 19 21H15" stroke="currentColor" stroke-width="2"/>
                        <path d="M10 17L15 12L10 7" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        <path d="M15 12H3" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    Sign In
                </button>
            </form>

            <p class="auth-switch">
                Don't have an account? 
                <a href="register.php">Register now</a>
            </p>
        </div>

        <!-- Footer Links -->
        <div class="auth-footer">
            <a href="#privacy">Privacy Policy</a>
            <span>·</span>
            <a href="#terms">Terms of Service</a>
            <span>·</span>
            <a href="#help">Help Center</a>
        </div>
    </div>
    
    <script>
        // Toggle password visibility
        function togglePassword(inputId, checkbox) {
            const input = document.getElementById(inputId);
            input.type = checkbox.checked ? 'text' : 'password';
        }
    </script>
    <script src="../assets/js/main.js"></script>
</body>
</html>