<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/auth.php';

// Require authentication
requireAuth();

// Check if booking_id is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    $_SESSION['error'] = "Invalid booking ID";
    header("Location: my-ticket.php");
    exit();
}

$booking_id = intval($_GET['id']);
$user_id = $_SESSION['user_id'];

// Verify booking belongs to user and is cancellable
$check_query = "SELECT * FROM bookings 
                WHERE id = ? 
                AND user_id = ? 
                AND booking_status = 'upcoming' 
                AND travel_date >= CURDATE()";
$stmt = mysqli_prepare($conn, $check_query);
mysqli_stmt_bind_param($stmt, "ii", $booking_id, $user_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$booking = mysqli_fetch_assoc($result);

if (!$booking) {
    $_SESSION['error'] = "Booking not found or cannot be cancelled";
    header("Location: my-ticket.php");
    exit();
}

// Check if travel date is at least 24 hours away
$travel_datetime = strtotime($booking['travel_date']);
$now = time();
$hours_until_travel = ($travel_datetime - $now) / 3600;

if ($hours_until_travel < 24) {
    $_SESSION['error'] = "Cannot cancel booking less than 24 hours before departure";
    header("Location: my-ticket.php");
    exit();
}

// Update booking status to cancelled
$cancel_query = "UPDATE bookings 
                 SET booking_status = 'cancelled', 
                     payment_status = 'refunded',
                     updated_at = NOW() 
                 WHERE id = ? AND user_id = ?";
$cancel_stmt = mysqli_prepare($conn, $cancel_query);
mysqli_stmt_bind_param($cancel_stmt, "ii", $booking_id, $user_id);

if (mysqli_stmt_execute($cancel_stmt)) {
    $_SESSION['success'] = "Booking cancelled successfully. Refund will be processed within 3-5 business days.";
} else {
    $_SESSION['error'] = "Failed to cancel booking. Please try again or contact support.";
}

header("Location: my-ticket.php");
exit();
?>