<?php
$page_title = "Home";
require_once 'includes/header.php';
require_once 'includes/navbar.php';

// Fetch promotions from database
$promo_query = "SELECT * FROM promotions WHERE status = 'active' ORDER BY created_at DESC LIMIT 3";
$promo_result = mysqli_query($conn, $promo_query);

// Fetch stations for dropdown
$stations_query = "SELECT * FROM stations ORDER BY city ASC";
$stations_result = mysqli_query($conn, $stations_query);
$stations = [];
while($station = mysqli_fetch_assoc($stations_result)) {
    $stations[] = $station;
}
?>

<!-- Hero Section -->
<section class="hero">
    <div class="container">
        <div class="hero-content">
            <div class="hero-text">
                <h1>Travel Smart, Travel Fast</h1>
                <p>Book your railway tickets with ease and comfort</p>
                <div class="hero-features">
                    <div class="feature-item">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13 2L3 14h8l-1 8 10-12h-8l1-8z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                        </svg>
                        <span>Fast</span>
                    </div>
                    <div class="feature-item">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="3" stroke="currentColor" stroke-width="2"/>
                            <path d="M12 2v3m0 14v3M2 12h3m14 0h3m-3.5-7.5l-2.1 2.1m-9.8 9.8l-2.1 2.1m0-14.2l2.1 2.1m9.8 9.8l2.1 2.1" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                        <span>Easy</span>
                    </div>
                    <div class="feature-item">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                            <path d="M12 6v6l4 2" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                        <span>Safe</span>
                    </div>
                </div>
                <a href="pages/schedule.php" class="btn-primary">Book Now</a>
            </div>
            <div class="hero-image">
                <img src="assets/img/trains/modern-train.png" alt="Modern Train Illustration">
            </div>
        </div>
    </div>
</section>

<!-- Search Section -->
<section class="search-section">
    <div class="container">
        <div class="search-card">
            <h2>Search Tickets</h2>
            <form action="pages/schedule.php" method="GET" class="search-form">
                <div class="form-grid">
                    <div class="form-group">
                        <label for="from">From</label>
                        <select name="from" id="from" required>
                            <option value="">Select Origin</option>
                            <?php foreach($stations as $station): ?>
                                <option value="<?php echo $station['id']; ?>">
                                    <?php echo htmlspecialchars($station['city']); ?> (<?php echo htmlspecialchars($station['code']); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="to">To</label>
                        <select name="to" id="to" required>
                            <option value="">Select Destination</option>
                            <?php foreach($stations as $station): ?>
                                <option value="<?php echo $station['id']; ?>">
                                    <?php echo htmlspecialchars($station['city']); ?> (<?php echo htmlspecialchars($station['code']); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="date">Date</label>
                        <input type="date" name="date" id="date" min="<?php echo date('Y-m-d'); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="passengers">Passengers</label>
                        <select name="passengers" id="passengers" required>
                            <option value="1">1 Adult</option>
                            <option value="2">2 Adults</option>
                            <option value="3">3 Adults</option>
                            <option value="4">4 Adults</option>
                            <option value="5">5 Adults</option>
                            <option value="6">6+ Adults</option>
                        </select>
                    </div>
                </div>

                <button type="submit" class="btn-search">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="11" cy="11" r="8" stroke="white" stroke-width="2"/>
                        <path d="M21 21l-4.35-4.35" stroke="white" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    Search Tickets
                </button>
            </form>
        </div>
    </div>
</section>

<!-- Why Choose Us Section -->
<section class="why-choose">
    <div class="container">
        <h2 class="section-title">Why Choose Us</h2>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13 2L3 14h8l-1 8 10-12h-8l1-8z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                    </svg>
                </div>
                <h3>Fast Booking</h3>
                <p>Book your tickets in just a few clicks with our streamlined process</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="5" y="2" width="14" height="20" rx="2" stroke="currentColor" stroke-width="2"/>
                        <path d="M12 18h.01M8 6h8M8 10h8" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                </div>
                <h3>Easy Access</h3>
                <p>Access your tickets anytime, anywhere with our mobile-friendly platform</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                        <path d="M12 6v6l4 2" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        <path d="M8 12h.01M16 12h.01" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                </div>
                <h3>Safe & Secure</h3>
                <p>Your data and payments are protected with bank-level security</p>
            </div>
        </div>
    </div>
</section>

<!-- Latest Promotions Section -->
<section class="promotions">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Latest Promotions</h2>
            <a href="pages/promotions.php" class="view-all">View All</a>
        </div>

        <div class="promo-grid">
            <?php if(mysqli_num_rows($promo_result) > 0): ?>
                <?php while($promo = mysqli_fetch_assoc($promo_result)): ?>
                    <div class="promo-card">
                        <div class="promo-image">
                            <?php if(!empty($promo['image']) && file_exists('../assets/img/promotions/' . $promo['image'])): ?>
                                <img src="../assets/img/promotions/<?php echo htmlspecialchars($promo['image']); ?>" 
                                     alt="<?php echo htmlspecialchars($promo['title']); ?>">
                            <?php else: ?>
                                <div class="promo-placeholder">
                                    <span><?php echo htmlspecialchars($promo['promo_type']); ?> Promotion</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="promo-content">
                            <h3><?php echo htmlspecialchars($promo['title']); ?></h3>
                            <p><?php echo htmlspecialchars(substr($promo['description'], 0, 100)); ?>...</p>
                            <div class="promo-footer">
                                <span class="promo-validity">Valid until: <?php echo date('M d, Y', strtotime($promo['end_date'])); ?></span>
                                <a href="pages/promotions.php?id=<?php echo $promo['id']; ?>" class="btn-promo">View Details</a>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <p>No promotions available at the moment.</p>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>