<nav class="navbar">
    <div class="container">
        <div class="nav-wrapper">
            <!-- Logo -->
            <a href="<?php echo BASE_URL; ?>index.php" class="logo">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect x="3" y="8" width="18" height="12" rx="2" stroke="white" stroke-width="2"/>
                    <path d="M7 8V6C7 4.89543 7.89543 4 9 4H15C16.1046 4 17 4.89543 17 6V8" stroke="white" stroke-width="2"/>
                    <circle cx="8" cy="17" r="1.5" fill="white"/>
                    <circle cx="16" cy="17" r="1.5" fill="white"/>
                </svg>
                <span class="logo-text">MyKivotosRailways</span>
            </a>

            <!-- Hamburger Menu (Mobile) -->
            <button class="hamburger" id="hamburger" aria-label="Menu">
                <span></span>
                <span></span>
                <span></span>
            </button>

            <!-- Navigation Menu -->
            <div class="nav-menu" id="navMenu">
                <ul class="nav-links">
                    <li><a href="<?php echo BASE_URL; ?>index.php" class="<?php echo ($current_page == 'index.php') ? 'active' : ''; ?>">Home</a></li>
                    
                    <?php if(isset($_SESSION['user_id'])): ?>
                        <li><a href="<?php echo BASE_URL; ?>pages/my-ticket.php" class="<?php echo ($current_page == 'my-ticket.php') ? 'active' : ''; ?>">My Ticket</a></li>
                    <?php endif; ?>
                    
                    <li><a href="<?php echo BASE_URL; ?>pages/schedule.php" class="<?php echo ($current_page == 'schedule.php') ? 'active' : ''; ?>">Schedule</a></li>
                    <li><a href="<?php echo BASE_URL; ?>pages/promotions.php" class="<?php echo ($current_page == 'promotions.php') ? 'active' : ''; ?>">Promotions</a></li>
                </ul>

                <div class="nav-auth">
                    <?php if(isset($_SESSION['user_id'])): ?>
                        <!-- User Logged In -->
                        <div class="user-menu">
                            <button class="user-btn" id="userBtn">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="12" cy="8" r="4" stroke="currentColor" stroke-width="2"/>
                                    <path d="M6 21C6 17.134 8.68629 14 12 14C15.3137 14 18 17.134 18 21" stroke="currentColor" stroke-width="2"/>
                                </svg>
                                <span><?php echo htmlspecialchars($_SESSION['username']); ?></span>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </button>
                            <div class="user-dropdown" id="userDropdown">
                                <?php if($_SESSION['role'] == 'admin'): ?>
                                    <a href="<?php echo BASE_URL; ?>admin/index.php">
                                        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="3" y="3" width="7" height="7" stroke="currentColor" stroke-width="2"/>
                                            <rect x="14" y="3" width="7" height="7" stroke="currentColor" stroke-width="2"/>
                                            <rect x="3" y="14" width="7" height="7" stroke="currentColor" stroke-width="2"/>
                                            <rect x="14" y="14" width="7" height="7" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        Admin Panel
                                    </a>
                                <?php endif; ?>
                                <a href="<?php echo BASE_URL; ?>pages/my-ticket.php">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="3" y="8" width="18" height="12" rx="2" stroke="currentColor" stroke-width="2"/>
                                        <path d="M7 8V6C7 4.89543 7.89543 4 9 4H15C16.1046 4 17 4.89543 17 6V8" stroke="currentColor" stroke-width="2"/>
                                    </svg>
                                    My Tickets
                                </a>
                                <a href="<?php echo BASE_URL; ?>pages/logout.php">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M15 3H19C20.1046 3 21 3.89543 21 5V19C21 20.1046 20.1046 21 19 21H15" stroke="currentColor" stroke-width="2"/>
                                        <path d="M10 17L15 12L10 7" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M15 12H3" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                    Logout
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- Not Logged In -->
                        <a href="<?php echo BASE_URL; ?>pages/login.php" class="btn-login">Login</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</nav>