<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/auth.php';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../pages/register.php");
    exit();
}

// Get and sanitize input
$full_name = sanitizeInput($_POST['fullname']);
$email = sanitizeInput($_POST['email']);
$username = sanitizeInput($_POST['username']);
$password = $_POST['password'];
$confirm_password = $_POST['confirm_password'];
$terms = isset($_POST['terms']) ? true : false;

// Store old values for form repopulation
$_SESSION['old_fullname'] = $full_name;
$_SESSION['old_email'] = $email;
$_SESSION['old_username'] = $username;

// Validation
$errors = [];

// Check empty fields
if (empty($full_name) || empty($email) || empty($username) || empty($password) || empty($confirm_password)) {
    $errors[] = "All fields are required";
}

// Validate full name
if (strlen($full_name) < 3) {
    $errors[] = "Full name must be at least 3 characters";
}

// Validate email using your function
if (!isValidEmail($email)) {
    $errors[] = "Invalid email format";
}

// Validate username
if (!preg_match('/^[a-zA-Z0-9_]{3,20}$/', $username)) {
    $errors[] = "Username must be 3-20 characters (letters, numbers, underscore only)";
}

// Validate password
if (strlen($password) < 6) {
    $errors[] = "Password must be at least 6 characters";
}

// Check password match
if ($password !== $confirm_password) {
    $errors[] = "Passwords do not match";
}

// Check terms agreement
if (!$terms) {
    $errors[] = "You must agree to the Terms & Conditions";
}

// If there are validation errors
if (!empty($errors)) {
    $_SESSION['error'] = implode("<br>", $errors);
    header("Location: ../pages/register.php");
    exit();
}

// Attempt registration using your auth function
$result = registerUser($conn, $full_name, $email, $username, $password);

if ($result['success']) {
    // Clear old form values
    unset($_SESSION['old_fullname']);
    unset($_SESSION['old_email']);
    unset($_SESSION['old_username']);
    
    // Set success message
    $_SESSION['success'] = "Registration successful! Please login to continue.";
    header("Location: ../pages/login.php");
    exit();
} else {
    // Registration failed
    $_SESSION['error'] = $result['message'];
    header("Location: ../pages/register.php");
    exit();
}
?>