<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/auth.php';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../pages/login.php");
    exit();
}

// Get and sanitize input
$identifier = sanitizeInput($_POST['email']); // Can be email or username
$password = $_POST['password'];
$remember = isset($_POST['remember']) ? true : false;

// Validation
if (empty($identifier) || empty($password)) {
    $_SESSION['error'] = "Please fill in all fields";
    $_SESSION['old_email'] = $identifier;
    header("Location: ../pages/login.php");
    exit();
}

// Attempt login using your auth function
$result = loginUser($conn, $identifier, $password);

if ($result['success']) {
    // Handle "Remember Me" if needed
    if ($remember) {
        // Optional: Implement remember me token functionality
        // For now, we'll just extend the session
        ini_set('session.gc_maxlifetime', 86400 * 30); // 30 days
        session_set_cookie_params(86400 * 30);
    }
    
    // Success message
    $_SESSION['success'] = "Welcome back, " . htmlspecialchars($_SESSION['username']) . "!";
    
    // Redirect based on role
    if ($result['role'] === 'admin') {
        header("Location: ../admin/index.php");
    } else {
        // Check if there's a redirect URL
        if (isset($_SESSION['redirect_to'])) {
            $redirect = $_SESSION['redirect_to'];
            unset($_SESSION['redirect_to']);
            
            // Jika path dimulai dengan /, langsung pakai (full path dari domain)
            if (substr($redirect, 0, 1) === '/') {
                header("Location: " . $redirect);
            } else {
                // Jika relative path, gabungkan dengan BASE_URL
                header("Location: " . BASE_URL . $redirect);
            }
        } else {
            header("Location: ../index.php");
        }
    }
    exit();
} else {
    // Login failed
    $_SESSION['error'] = $result['message'];
    $_SESSION['old_email'] = $identifier;
    header("Location: ../pages/login.php");
    exit();
}
?>