<?php
$page_title = "Dashboard";
include 'includes/admin-header.php';

// Get statistics
$stats = [];

// Total bookings
$query = "SELECT COUNT(*) as total FROM bookings";
$result = mysqli_query($conn, $query);
$stats['total_bookings'] = mysqli_fetch_assoc($result)['total'];

// Pending bookings
$query = "SELECT COUNT(*) as total FROM bookings WHERE payment_status = 'pending'";
$result = mysqli_query($conn, $query);
$stats['pending_bookings'] = mysqli_fetch_assoc($result)['total'];

// Total users
$query = "SELECT COUNT(*) as total FROM users WHERE role = 'user'";
$result = mysqli_query($conn, $query);
$stats['total_users'] = mysqli_fetch_assoc($result)['total'];

// Total trains
$query = "SELECT COUNT(*) as total FROM trains";
$result = mysqli_query($conn, $query);
$stats['total_trains'] = mysqli_fetch_assoc($result)['total'];

// Total stations
$query = "SELECT COUNT(*) as total FROM stations";
$result = mysqli_query($conn, $query);
$stats['total_stations'] = mysqli_fetch_assoc($result)['total'];

// Total revenue (confirmed bookings)
$query = "SELECT SUM(total_price) as revenue FROM bookings WHERE payment_status = 'confirmed'";
$result = mysqli_query($conn, $query);
$stats['total_revenue'] = mysqli_fetch_assoc($result)['revenue'] ?? 0;

// Recent bookings
$query = "SELECT b.*, u.full_name, u.email, 
          s1.station_name as origin_name, s2.station_name as destination_name,
          t.train_name
          FROM bookings b 
          JOIN users u ON b.user_id = u.id 
          JOIN schedules sc ON b.schedule_id = sc.id
          JOIN trains t ON sc.train_id = t.id
          JOIN stations s1 ON sc.origin_station_id = s1.id
          JOIN stations s2 ON sc.destination_station_id = s2.id
          ORDER BY b.created_at DESC LIMIT 10";
$recent_bookings = mysqli_query($conn, $query);

include 'includes/admin-sidebar.php';
?>

<div class="admin-container">
    <div class="page-header">
        <div>
            <h1>Dashboard</h1>
            <p>Welcome back, <?php echo $_SESSION['full_name']; ?>! Here's what's happening today.</p>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">📊</div>
            <div class="stat-info">
                <h3><?php echo number_format($stats['total_bookings']); ?></h3>
                <p>Total Bookings</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">⏳</div>
            <div class="stat-info">
                <h3><?php echo number_format($stats['pending_bookings']); ?></h3>
                <p>Pending Bookings</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">👥</div>
            <div class="stat-info">
                <h3><?php echo number_format($stats['total_users']); ?></h3>
                <p>Total Users</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">🚄</div>
            <div class="stat-info">
                <h3><?php echo number_format($stats['total_trains']); ?></h3>
                <p>Total Trains</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">🏢</div>
            <div class="stat-info">
                <h3><?php echo number_format($stats['total_stations']); ?></h3>
                <p>Total Stations</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">💰</div>
            <div class="stat-info">
                <h3>Rp <?php echo number_format($stats['total_revenue'], 0, ',', '.'); ?></h3>
                <p>Total Revenue</p>
            </div>
        </div>
    </div>

    <!-- Recent Bookings -->
    <div class="admin-card">
        <div class="card-header">
            <h2>Recent Bookings</h2>
            <a href="bookings.php" class="btn btn-outline btn-sm">View All</a>
        </div>

        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Booking Code</th>
                        <th>Customer</th>
                        <th>Route</th>
                        <th>Train</th>
                        <th>Travel Date</th>
                        <th>Passengers</th>
                        <th>Total Price</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(mysqli_num_rows($recent_bookings) > 0): ?>
                        <?php while($booking = mysqli_fetch_assoc($recent_bookings)): ?>
                            <tr>
                                <td><strong><?php echo htmlspecialchars($booking['booking_code']); ?></strong></td>
                                <td>
                                    <div>
                                        <strong><?php echo htmlspecialchars($booking['full_name']); ?></strong><br>
                                        <small style="color: var(--gray);"><?php echo htmlspecialchars($booking['email']); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <small><?php echo htmlspecialchars($booking['origin_name']); ?> → <?php echo htmlspecialchars($booking['destination_name']); ?></small>
                                </td>
                                <td><?php echo htmlspecialchars($booking['train_name']); ?></td>
                                <td><?php echo date('d M Y', strtotime($booking['travel_date'])); ?></td>
                                <td><?php echo $booking['passengers']; ?> seat(s)</td>
                                <td><strong>Rp <?php echo number_format($booking['total_price'], 0, ',', '.'); ?></strong></td>
                                <td>
                                    <span class="status-badge status-<?php echo $booking['payment_status']; ?>">
                                        <?php echo ucfirst($booking['payment_status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="table-actions">
                                        <a href="bookings.php?view=<?php echo $booking['id']; ?>" class="btn btn-primary btn-sm btn-icon" title="View">
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                                <circle cx="12" cy="12" r="3"></circle>
                                            </svg>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="9" style="text-align: center; padding: 40px;">
                                <div class="empty-state">
                                    <p>No bookings found</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/admin-footer.php'; ?>