const sidebarToggle = document.getElementById('sidebarToggle');
const adminSidebar = document.getElementById('adminSidebar');
const body = document.body;

if (sidebarToggle && adminSidebar) {
    sidebarToggle.addEventListener('click', () => {
        adminSidebar.classList.toggle('collapsed');
        body.classList.toggle('sidebar-collapsed');
        
        // Save state to localStorage
        const isCollapsed = adminSidebar.classList.contains('collapsed');
        localStorage.setItem('sidebarCollapsed', isCollapsed);
    });
    
    // Restore sidebar state from localStorage
    const savedState = localStorage.getItem('sidebarCollapsed');
    if (savedState === 'true') {
        adminSidebar.classList.add('collapsed');
        body.classList.add('sidebar-collapsed');
    }
}

// User Menu Dropdown
const userMenuBtn = document.querySelector('.user-menu-btn');
const userDropdown = document.querySelector('.user-dropdown');

if (userMenuBtn && userDropdown) {
    userMenuBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        userDropdown.classList.toggle('active');
    });
    
    // Close dropdown when clicking outside
    document.addEventListener('click', (e) => {
        if (!e.target.closest('.admin-user-menu')) {
            userDropdown.classList.remove('active');
        }
    });
}

// Auto-hide alerts after 5 seconds
const alerts = document.querySelectorAll('.alert-success, .alert-error');
alerts.forEach(alert => {
    setTimeout(() => {
        alert.style.animation = 'fadeOut 0.3s ease';
        setTimeout(() => alert.remove(), 300);
    }, 5000);
});

// Confirm delete actions
const deleteButtons = document.querySelectorAll('[data-confirm]');
deleteButtons.forEach(button => {
    button.addEventListener('click', (e) => {
        const message = button.dataset.confirm || 'Are you sure you want to delete this?';
        if (!confirm(message)) {
            e.preventDefault();
        }
    });
});